<?php
require 'conexion.php';


if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $nombre = trim($_POST['fullname']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm = $_POST['confirm'];

    if ($password !== $confirm) {
        die("Las contraseñas no coinciden.");
    }

    // Validar si ya existe el correo
    $verificar = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $verificar->bind_param("s", $email);
    $verificar->execute();
    $verificar->store_result();
    
    if ($verificar->num_rows > 0) {
        // Redirige a un mensaje de error o vuelve al formulario con error
        header("Location: registro.php?error=correo_en_uso");
        exit(); // <- MUY importante para que no siga el script
    }
    
    // Encriptar y registrar el usuario
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $conn->prepare("INSERT INTO users (full_name, email, password) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $nombre, $email, $hashed_password);

    
    if ($stmt->execute()) {
        // Redirigir si el registro fue exitoso
        header("Location: login.php?registro=exito");
        exit();
    } else {
        // Mostrar mensaje de error o redirigir
        header("Location: registro.php?error=registro_fallido");
        exit();
    }
}