<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}

$usuario = $_SESSION['user'];
include ("partes/imagenes.php"); 
?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página de Inicio</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/css/uikit.min.css" />
    <link rel="stylesheet" href="css/style2.css">
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/js/uikit-icons.min.js"></script>
</head>
<body>

<!-- Navbar -->
<nav class="uk-navbar-container" style="background-color: #0A1A2F;>
    <div class="uk-container uk-container-expand">
        <div class="uk-margin-xlarge-left uk-margin-xlarge-right">
            <div uk-navbar>
                <div class="uk-navbar-left">
                    <a class="uk-navbar-item uk-logo" href="#" style="color: #14c5dc;">ICS</a>
                </div>
                <div class="uk-navbar-right">
                    <ul class="uk-navbar-nav">
                        <li>
                            <a href="#">
                                <img class="uk-border-circle" src="<?php echo $posicion . $imagenes2[0]['img']; ?>" width="40" height="40" alt="Avatar">
                            </a>
                            <div class="uk-navbar-dropdown">
                                <ul class="uk-nav uk-navbar-dropdown-nav">
                                    <li class="uk-nav-header">Perfil</li>
                                    <li><a href="#">Nombre: <?php echo htmlspecialchars($usuario['full_name']); ?></a></li>
                                    <li><a href="#">Correo: <?php echo htmlspecialchars($usuario['email']); ?></a></li>
                                    <li><a href="#">Descripción: <?php echo isset($usuario['descripcion']) ? htmlspecialchars($usuario['descripcion']) : 'No disponible'; ?></a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="logout.php">Cerrar sesión</a></li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</nav>

<!-- Contenido principal -->
<div class="uk-section uk-section-muted uk-padding-large" style="background-color: #0A1A2F;">
    <div class="uk-container">
        <h2 class="uk-heading-line"><span>Bienvenido, <?php echo htmlspecialchars($usuario['full_name']); ?></span></h2>
    </div>
</div>

<div class="container">

  <!-- Header -->
  <div class="header">
    <div class="bienvenido">
      <small>Tu resumen de hoy</small>
    </div>
    <div class="stats">
      <p>Prestamos activos</p>
      <div class="number" id="prestamos-activos">5</div>
    </div>
    <div class="stats">
      <p>Pagos hoy</p>
      <div class="number" id="pagos-hoy">3</div>
    </div>
    <div class="stats recovered">
      <p>Recuperado</p>
      <div class="number" id="porcentaje-recuperado">63%</div>
    </div>
  </div>

  <!-- Resumen financiero -->
  <div class="resumen">
    <h2>Resumen Financiero</h2>
    <div class="flex-row">
      <div class="chart-container">
        <canvas id="pieChart"></canvas>
      </div>
      <div class="legend">
        <div class="legend-item">
          <span class="legend-color legend-prestado"></span> Total prestado: <span id="total-prestado">RD$120,000</span>
        </div>
        <div class="legend-item">
          <span class="legend-color legend-recuperado"></span> Total recuperado: <span id="total-recuperado">RD$75,000</span>
        </div>
        <div class="legend-item">
          <span class="legend-color legend-pendiente"></span> Pendiente por cobrar: <span id="pendiente-cobrar">RD$45,000</span>
        </div>
      </div>
    </div>
  </div>

  <!-- Acciones r��pidas -->
  <div class="acciones">
    <div class="accion-btn" onclick="alert('Nuevo Cliente')">Nuevo Cliente</div>
    <div class="accion-btn" onclick="alert('Nuevo Pr��stamo')">Nuevo Pr��stamo</div>
    <div class="accion-btn" onclick="alert('Ver Clientes')">Ver Clientes</div>
    <div class="accion-btn" onclick="alert('Registrar Pago')">Registrar Pago</div>
  </div>

  <!-- Calculadora -->
  <div class="calculadora">
    <h2>Calculadora de Pr��stamos</h2>
    <form id="calcForm">
      <div class="form-group">
        <label for="monto">Monto del pr��stamo (RD$):</label>
        <input type="number" id="monto" required min="1" step="0.01" />
      </div>
      <div class="form-group">
        <label for="tasa">Tasa de inter��s anual (%):</label>
        <input type="number" id="tasa" required min="0" step="0.01" />
      </div>
      <div class="form-group">
        <label for="plazo">Plazo (a�0�9os):</label>
        <input type="number" id="plazo" required min="0.01" step="0.01" />
      </div>
      <div class="form-group">
        <label for="tipoInteres">Tipo de inter��s:</label>
        <select id="tipoInteres" required>
          <option value="simple">Inter��s Simple</option>
          <option value="compuesto">Inter��s Compuesto</option>
        </select>
      </div>
      <button type="submit" class="calc-btn">Calcular</button>
    </form>
    <div class="resultado" id="resultado"></div>
  </div>

</div>

<!-- Chart.js CDN -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  // Datos iniciales (pueden venir din��micos)
  const prestamos = {
    totalPrestado: 120000,
    totalRecuperado: 75000,
    pendienteCobrar: 45000,
  };

  // Actualizar resumen num��rico
  document.getElementById('total-prestado').textContent = `RD$${prestamos.totalPrestado.toLocaleString()}`;
  document.getElementById('total-recuperado').textContent = `RD$${prestamos.totalRecuperado.toLocaleString()}`;
  document.getElementById('pendiente-cobrar').textContent = `RD$${prestamos.pendienteCobrar.toLocaleString()}`;

  // Datos para la gr��fica pastel
  const data = {
    labels: ['Total prestado', 'Total recuperado', 'Pendiente por cobrar'],
    datasets: [{
      data: [prestamos.totalPrestado, prestamos.totalRecuperado, prestamos.pendienteCobrar],
      backgroundColor: ['#1FBB7D', '#0D3B66', '#F45B69'],
      hoverOffset: 30
    }]
  };

  // Configuraci��n del gr��fico
  const config = {
    type: 'pie',
    data: data,
    options: {
      responsive: true,
      plugins: {
        legend: {
          display: false
        }
      }
    }
  };

  // Crear el gr��fico
  const pieChart = new Chart(
    document.getElementById('pieChart'),
    config
  );

  // Calculadora
  document.getElementById('calcForm').addEventListener('submit', function(e) {
    e.preventDefault();

    const monto = parseFloat(document.getElementById('monto').value);
    const tasa = parseFloat(document.getElementById('tasa').value) / 100;
    const plazo = parseFloat(document.getElementById('plazo').value);
    const tipo = document.getElementById('tipoInteres').value;

    let totalPagar;
    if (tipo === 'simple') {
      // Inter��s simple: Monto + Monto * tasa * plazo
      totalPagar = monto * (1 + tasa * plazo);
    } else {
      // Inter��s compuesto: Monto * (1 + tasa)^plazo
      totalPagar = monto * Math.pow((1 + tasa), plazo);
    }

    const intereses = totalPagar - monto;

    document.getElementById('resultado').innerHTML = `
      <p>Monto inicial: RD$${monto.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</p>
      <p>Inter��s generado: RD$${intereses.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</p>
      <p><strong>Total a pagar: RD$${totalPagar.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</strong></p>
    `;
  });
</script>

</body>
<script src="js/scripts.js"></script>
</html>
