<?php
include("conexion.php");
session_start(); 

$user_id = $_SESSION['user']['id'] ?? null;


if (!$user_id) {
  echo "<div class='uk-alert-danger uk-alert' uk-alert><p>Usuario no autenticado.</p></div>";
  exit;
}


$tiene_activos = false;
$result = $conn->query("SELECT 1 FROM prestamos WHERE user_id = $user_id AND estado = 'activo' LIMIT 1");
if ($result && $result->num_rows > 0) {
  $tiene_activos = true;
}

$prestamos = $conn->query("SELECT id, monto, fecha_prestamo FROM prestamos WHERE user_id = $user_id AND estado = 'activo'");
?>

<div id="modal-pago" uk-modal>
  <div class="uk-modal-dialog uk-modal-body">
    <h2 class="uk-modal-title">Registrar Pago</h2>
    
    <form action="registrar_pago.php" method="POST">
      
      <?php if ($prestamos && $prestamos->num_rows > 0): ?>
        <div class="uk-margin">
          <label>Selecciona el préstamo</label>
          <select class="uk-select" name="prestamo_id" required>
            <option value="">-- Selecciona un préstamo --</option>
            <?php while($p = $prestamos->fetch_assoc()): ?>
              <option value="<?= $p['id'] ?>">
                RD$<?= number_format($p['monto'], 2) ?> - <?= date("d/m/Y", strtotime($p['fecha_prestamo'])) ?>
              </option>
            <?php endwhile; ?>
          </select>
        </div>
      <?php else: ?>
        <div class="uk-alert-warning uk-alert" uk-alert>
          <p>No tienes préstamos activos disponibles para registrar pagos.</p>
        </div>
      <?php endif; ?>

      <div class="uk-margin">
        <label>Monto del Pago</label>
        <input class="uk-input" type="number" step="0.01" name="monto" required>
      </div>

      <button class="uk-button uk-button-primary" id="btnRegistrarPago" onclick="UIkit.modal('#modal-pago').show();">
          Registrar Pago
      </button>
      <button class="uk-button uk-button-default uk-modal-close" type="button">Cancelar</button>
    </form>
  </div>
</div>
