<?php
include("conexion.php");
$user_id = $_SESSION['user']['id'];

$query = "
  SELECT pagos.monto, pagos.fecha, prestamos.monto AS monto_prestamo, prestamos.fecha_prestamo
  FROM pagos
  INNER JOIN prestamos ON pagos.prestamo_id = prestamos.id
  WHERE prestamos.user_id = $user_id
  ORDER BY pagos.fecha DESC
";

$pagos = $conn->query($query);
?>

<div id="modal-historial" uk-modal>
  <div class="uk-modal-dialog uk-modal-body">
    <h2 class="uk-modal-title">Historial de Pagos</h2>

    <?php if ($pagos && $pagos->num_rows > 0): ?>
      <div class="uk-overflow-auto">
        <table class="uk-table uk-table-divider uk-table-striped uk-table-hover uk-light" id="tablaHistorial">
          <thead>
            <tr>
              <th>Monto del Pago</th>
              <th>Fecha del Pago</th>
              <th>Monto del Préstamo</th>
              <th>Fecha del Préstamo</th>
            </tr>
          </thead>
          <tbody>
            <?php while($p = $pagos->fetch_assoc()): ?>
              <tr>
                <td>RD$<?= number_format($p['monto'], 2) ?></td>
                <td><?= date("d/m/Y", strtotime($p['fecha'])) ?></td>
                <td>RD$<?= number_format($p['monto_prestamo'], 2) ?></td>
                <td><?= date("d/m/Y", strtotime($p['fecha_prestamo'])) ?></td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    <?php else: ?>
      <div class="uk-alert-warning uk-alert" uk-alert>
        <p>No tienes pagos registrados aún.</p>
      </div>
    <?php endif; ?>

    <button class="uk-button uk-button-default uk-modal-close">Cerrar</button>
  </div>
</div>
