<?php
session_start();
require 'conexion.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, full_name, email, password FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado->num_rows === 1) {
        $usuario = $resultado->fetch_assoc();

        if (password_verify($password, $usuario['password'])) {
            $_SESSION['user'] = [
                'id' => $usuario['id'],
                'full_name' => $usuario['full_name'],
                'email' => $usuario['email']
            ];
            header("Location: sesion_iniciada.php");
            exit();
        } else {
            $error = "Contraseña incorrecta.";
        }
    } else {
        $error = "No existe una cuenta con ese correo.";
    }
}

include("partes/imagenes.php");
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login | Prestify</title>
  <link rel="stylesheet" href="css/style.css">
</head>
<body>

  <div class="login-container">
    <a href="Fullcode.php">
      <img src="<?php echo $posicion . $arreglo[0]['img']; ?>" width="175px" height="100px" alt="Logo prestify">
    </a>

    <h2>Bienvenido a Prestify</h2>

    <?php if (isset($error)): ?>
      <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>

    <form method="POST" action="">
      <div class="form-group">
        <label for="email">Correo electrónico</label>
        <input type="text" id="email" name="email" placeholder="Ingresa tu correo" required>
      </div>

      <div class="form-group">
        <label for="password">Contraseña</label>
        <input type="password" id="password" name="password" placeholder="Ingresa tu contraseña" required>
      </div>

      <button type="submit" class="login-button">Iniciar Sesión</button>

      <div class="register-link">
        ¿Aún no tienes una cuenta? <a href="register.php">Registrarse</a>
      </div>
    </form>
  </div>

</body>
</html>
