<?php
include("conexion.php");
$user_id = $_SESSION['user']['id'];


$prestamos = $conn->query("
  SELECT p.*, 
    (SELECT IFNULL(SUM(monto), 0) FROM pagos WHERE prestamo_id = p.id) AS total_pagado
  FROM prestamos p
  WHERE user_id = $user_id
");
?>

<div id="modal-prestamos" uk-modal>
  <div class="uk-modal-dialog uk-modal-body">
    <h2 class="uk-modal-title">Mis Préstamos</h2>

    <div class="uk-margin">
      <label for="filtroEstado">Filtrar por estado:</label>
      <select id="filtroEstado" class="uk-select" onchange="filtrarTabla()">
        <option value="todos">Todos</option>
        <option value="activo">Activo</option>
        <option value="pagado">Pagado</option>
      </select>
    </div>
    <div id="mensajeVacio" class="uk-alert-warning uk-alert" uk-alert style="display: none;">
      <p>No tienes préstamos activos disponibles.</p>
    </div>

    <div class="uk-overflow-auto" id="tablaContainer">
      <table class="uk-table uk-table-divider uk-table-striped" id="tablaPrestamos">
        <thead>
          <tr>
            <th>Monto</th>
            <th>Tasa</th>
            <th>Plazo</th>
            <th>Frecuencia</th>
            <th>Tipo</th>
            <th>Cuota estimada</th>
            <th>Total a pagar (Con intereses)</th>
            <th>Estado</th>
            <th>Fecha</th>
          </tr>
        </thead>
        <tbody>
          <?php while($row = $prestamos->fetch_assoc()): 
            $monto = $row['monto'];
            $tasa = $row['tasa'] / 100;
            $plazo = $row['plazo'];
            $frecuencia = $row['frecuencia_pago'];
            $tipo = $row['tipo_interes'];
            $estado = strtolower($row['estado']);
            $pagado = $row['total_pagado'];
            $cuotas = match($frecuencia) {
              "mensual" => $plazo * 12,
              "quincenal" => $plazo * 24,
              "semanal" => $plazo * 52,
              "anual" => $plazo,
              default => 1
            };


            $total = ($tipo === 'simple') 
              ? $monto * (1 + $tasa * $plazo) 
              : $monto * pow(1 + $tasa, $plazo);

            $cuota = $total / $cuotas;
            $saldo_restante = $total - $pagado;
          ?>
          <tr data-estado="<?= $estado ?>">
            <td>RD$<?= number_format($monto, 2) ?></td>
            <td><?= number_format($row['tasa'], 2) ?>%</td>
            <td><?= $plazo ?> años</td>
            <td><?= ucfirst($frecuencia) ?></td>
            <td><?= ucfirst($tipo) ?></td>
            <td>RD$<?= number_format($cuota, 2) ?></td>
            <td>RD$<?= number_format($saldo_restante, 2) ?></td>
            <td><?= ucfirst($estado) ?></td>
            <td><?= date("d/m/Y", strtotime($row['fecha_prestamo'])) ?></td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>

    <button class="uk-button uk-button-default uk-modal-close">Cerrar</button>
  </div>
</div>

<script>
function filtrarTabla() {
  const filtro = document.getElementById("filtroEstado").value;
  const filas = document.querySelectorAll("#tablaPrestamos tbody tr");
  const mensajeVacio = document.getElementById("mensajeVacio");
  const tablaContainer = document.getElementById("tablaContainer");

  let visibleCount = 0;

  filas.forEach(fila => {
    const estado = fila.getAttribute("data-estado");
    const visible = (filtro === "todos" || filtro === estado);
    fila.style.display = visible ? "" : "none";
    if (visible) visibleCount++;
  });

  if (visibleCount === 0) {
    tablaContainer.style.display = "none";
    mensajeVacio.style.display = "block";
  } else {
    tablaContainer.style.display = "block";
    mensajeVacio.style.display = "none";
  }
}

</script>
