<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}

$usuario = $_SESSION['user'];
include ("partes/imagenes.php"); 
include("conexion.php");
// Conexión ya está incluida
$user_id = $usuario['id']; // o como se llame exactamente el ID del usuario

// Prestamos activos
$res_activos = $conn->query("SELECT COUNT(*) AS total_activos FROM prestamos WHERE user_id = $user_id AND estado = 'activo'");
$total_activos = $res_activos->fetch_assoc()['total_activos'];

// Pagos realizados hoy
$hoy = date('Y-m-d');

$res_pagos = $conn->query("
    SELECT COUNT(*) AS pagos_hoy 
    FROM pagos 
    INNER JOIN prestamos ON pagos.prestamo_id = prestamos.id 
    WHERE prestamos.user_id = $user_id 
    AND DATE(pagos.fecha) = '$hoy'
");

$pagos_hoy = $res_pagos->fetch_assoc()['pagos_hoy'] ?? 0;

// Total prestado (sumatoria de todos los préstamos del usuario)
$res_total_prestado = $conn->query("SELECT SUM(monto) AS total_prestado FROM prestamos WHERE user_id = $user_id");
$total_prestado = $res_total_prestado->fetch_assoc()['total_prestado'] ?? 0;

// Total a pagar con intereses
$res_total_con_interes = $conn->query("
    SELECT SUM(
        CASE 
            WHEN tipo_interes = 'simple' THEN monto * (1 + tasa / 100 * plazo)
            ELSE monto * POW(1 + tasa / 100, plazo)
        END
    ) AS total_a_pagar
    FROM prestamos
    WHERE user_id = $user_id
");
$total_a_pagar = $res_total_con_interes->fetch_assoc()['total_a_pagar'] ?? 0;

// Total pagado
$res_pagado = $conn->query("
    SELECT SUM(pagos.monto) AS total_pagado
    FROM pagos
    INNER JOIN prestamos ON pagos.prestamo_id = prestamos.id
    WHERE prestamos.user_id = $user_id
");
$total_pagado = $res_pagado->fetch_assoc()['total_pagado'] ?? 0;

// Pendiente
$pendiente = $total_a_pagar - $total_pagado;
$pendiente = max(0, $pendiente);

// Porcentaje pagado
$porcentaje_pagado = $total_a_pagar > 0 ? round(($total_pagado / $total_a_pagar) * 100) : 0;
?>


<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prestify - Inicio</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/css/uikit.min.css" />
    <link rel="stylesheet" href="css/style2.css">
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/js/uikit-icons.min.js"></script>
</head>
<body>

<!-- Navbar -->
<nav class="uk-navbar-container" style="background-color: #0A1A2F;">
    <div class="uk-container uk-container-expand">
        <div class="uk-margin-xlarge-left uk-margin-xlarge-right">
            <div uk-navbar>
                <div class="uk-navbar-left">
                    <img src="<?php echo $posicion . $arreglo[0]['img']; ?>" width="90px" height="90px" alt="">
                </div>
                <div class="uk-navbar-right">
                    <ul class="uk-navbar-nav">
                        <li>
                            <a href="#">
                                <img class="uk-border-circle" src="<?php echo $posicion . $imagenes2[0]['img']; ?>" width="40" height="40" alt="Avatar">
                            </a>
                            <div class="uk-navbar-dropdown">
                                <ul class="uk-nav uk-navbar-dropdown-nav">
                                    <li class="uk-nav-header">Perfil</li>
                                    <li><a href="#">Nombre: <?php echo htmlspecialchars($usuario['full_name']); ?></a></li>
                                    <li><a href="#">Correo: <?php echo htmlspecialchars($usuario['email']); ?></a></li>
                                    <li><a href="#">Descripción: <?php echo isset($usuario['descripcion']) ? htmlspecialchars($usuario['descripcion']) : 'No disponible'; ?></a></li>
                                    <li class="uk-nav-divider"></li>
                                    <li><a href="logout.php">Cerrar sesión</a></li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</nav>

<!-- Contenido principal -->
<div class="uk-section uk-section-muted uk-padding-large" style="background-color: #0A1A2F;">
    <div class="uk-container">
        <h2 class="uk-text-left" style="color: #ffffff; margin-left: 20px;">
  Bienvenido, <?php echo htmlspecialchars($usuario['full_name']); ?>
</h2>

    </div>
</div>

<div class="container">

  <!-- Header -->
  <div class="header">
    <div class="bienvenido">
      <small>Tu resumen de hoy</small>
    </div>
    <div class="stats">
      <p>Prestamos</p>
      <div class="number" id="prestamos-activos"><?php echo $total_activos; ?></div>
    </div>
    <div class="stats">
      <p>Pagos hoy</p>
      <div class="number" id="pagos-hoy"><?php echo $pagos_hoy; ?></div>
    </div>
    <div class="stats recovered">
      <p>Pago total</p>
      <div class="number" id="porcentaje-recuperado"><?php echo $porcentaje_pagado; ?>%</div>
    </div>
  </div>

  <!-- Resumen -->
  <div class="resumen">
    <h2>Resumen Financiero</h2>
    <div class="flex-row">
        <div style="display:none;">
  <div id="total-prestado"></div>
  <div id="total-recuperado"></div>
  <div id="pendiente-cobrar"></div>
</div>
      <div class="chart-container">
        <canvas id="pieChart"></canvas>
      </div>
      <div class="legend-financiera">
  <div class="item-financiero total-a-pagar">
    <span class="color-caja" style="background-color: #0D3B66;"></span>
    <div>
      <div class="etiqueta">Total a pagar</div>
      <div class="valor">RD$<?php echo number_format($total_a_pagar, 2); ?></div>
    </div>
  </div>

  <div class="item-financiero total-pagado">
    <span class="color-caja" style="background-color: #1FBB7D;"></span>
    <div>
      <div class="etiqueta">Total pagado</div>
      <div class="valor">RD$<?php echo number_format($total_pagado, 2); ?></div>
    </div>
  </div>

  <div class="item-financiero pendiente">
    <span class="color-caja" style="background-color: #F45B69;"></span>
    <div>
      <div class="etiqueta">Pendiente por cobrar</div>
      <div class="valor">RD$<?php echo number_format($pendiente, 2); ?></div>
    </div>
  </div>
</div>
    </div>
  </div>

  <!-- Acciones -->
  <div class="acciones">
    <a href="#modal-prestamo" class="accion-btn" uk-toggle>Nuevo préstamo</a>
    <a href="#modal-prestamos" class="accion-btn" uk-toggle>Ver préstamos</a>
    <a href="#modal-pago" uk-toggle class="accion-btn">Registrar Pago</a>
    <a href="#modal-historial" class="accion-btn" uk-toggle>Historial de Pagos</a>
  </div>

  <!-- Calculadora -->
  <div class="calculadora">
    <h2>Calculadora de Prestamos</h2>
    <form id="calcForm">
      <div class="form-group">
        <label for="monto">Monto del prestamo (RD$):</label>
        <input type="number" id="monto" required min="1" step="0.01" />
      </div>
      <div class="form-group">
        <label for="tasa">Tasa de interes anual (%):</label>
        <input type="number" id="tasa" required min="0" step="0.01" />
      </div>
      <div class="form-group">
        <label for="plazo">Plazo (años):</label>
        <input type="number" id="plazo" required min="0.01" step="0.01" />
      </div>
      <div class="form-group">
        <label for="tipoInteres">Tipo de interes</label>
        <select id="tipoInteres" required>
          <option value="simple">Intereres Simple</option>
          <option value="compuesto">Interes Compuesto</option>
        </select>
      </div>
      <button type="submit" class="calc-btn">Calcular</button>
    </form>
    <div class="resultado" id="resultado"></div>
  </div>

</div>


<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const prestamos = {
      totalPrestado: <?php echo $total_a_pagar ?? 0; ?>,
      totalRecuperado: <?php echo $total_pagado ?? 0; ?>,
      pendienteCobrar: <?php echo $pendiente ?? 0; ?>,
    };

    // Actualizar resumen
    document.getElementById('total-prestado').textContent = `RD$${prestamos.totalPrestado.toLocaleString()}`;
    document.getElementById('total-recuperado').textContent = `RD$${prestamos.totalRecuperado.toLocaleString()}`;
    document.getElementById('pendiente-cobrar').textContent = `RD$${prestamos.pendienteCobrar.toLocaleString()}`;

    // Crear gráfica
    const data = {
      labels: ['Total a pagar', 'Total pagado', 'Pendiente por cobrar'],
      datasets: [{
        data: [prestamos.totalPrestado, prestamos.totalRecuperado, prestamos.pendienteCobrar],
        backgroundColor: ['#0D3B66', '#1FBB7D', '#F45B69'],
        hoverOffset: 30
      }]
    };
        const config = {
      type: 'pie',
      data: data,
      options: {
        responsive: true,
        plugins: {
          legend: {
            display: false
          }
        }
      }
    };

    const pieChartCanvas = document.getElementById('pieChart');
    if (pieChartCanvas) {
      new Chart(pieChartCanvas, config);
    }

    // Calculadora
    document.getElementById('calcForm').addEventListener('submit', function (e) {
      e.preventDefault();

      const monto = parseFloat(document.getElementById('monto').value);
      const tasa = parseFloat(document.getElementById('tasa').value) / 100;
      const plazo = parseFloat(document.getElementById('plazo').value);
      const tipo = document.getElementById('tipoInteres').value;

      let totalPagar;
      if (tipo === 'simple') {
        totalPagar = monto * (1 + tasa * plazo);
      } else {
        totalPagar = monto * Math.pow((1 + tasa), plazo);
      }

      const intereses = totalPagar - monto;

      document.getElementById('resultado').innerHTML = `
        <p>Monto inicial: RD$${monto.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</p>
        <p>Interés generado: RD$${intereses.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</p>
        <p><strong>Total a pagar: RD$${totalPagar.toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})}</strong></p>
      `;
    });

    // Filtro de préstamos
    window.filtrarTabla = function () {
      const filtro = document.getElementById("filtroEstado").value;
      const filas = document.querySelectorAll("#tablaPrestamos tbody tr");
      const mensajeVacio = document.getElementById("mensajeVacio");
      const tablaContainer = document.getElementById("tablaContainer");
      const btnRegistrarPago = document.getElementById("btnRegistrarPago");

      let visibleCount = 0;

      filas.forEach(fila => {
        const estado = fila.getAttribute("data-estado");
        const visible = (filtro === "todos" || filtro === estado);
        fila.style.display = visible ? "" : "none";
        if (visible) visibleCount++;
      });

      if (visibleCount === 0) {
        tablaContainer.style.display = "none";
        mensajeVacio.style.display = "block";
        btnRegistrarPago.disabled = true;
      } else {
        tablaContainer.style.display = "block";
        mensajeVacio.style.display = "none";
        btnRegistrarPago.disabled = false;
      }
    };
  });
</script>
<?php
include ("historial_pagos.php");
include ("form_pago.php");
include ("partes/form_ver_prestamos.php");
include ("partes/formulario_prestamo.php"); 
?>
</body>
<script src="js/scripts.js"></script>
</html>
