<?php
session_start();
include("conexion.php");

$user_id = $_SESSION['user']['id'];

$resultado = $conn->query("SELECT * FROM prestamos WHERE user_id = $user_id ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html>
<head>
    <title>Mis Préstamos</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/css/uikit.min.css" />
</head>
<body class="uk-container uk-padding">

<h2 class="uk-heading-line uk-text-center"><span>Préstamos Registrados</span></h2>

<table class="uk-table uk-table-divider uk-table-hover uk-table-striped">
    <thead>
        <tr>
            <th>Monto</th>
            <th>Tasa</th>
            <th>Plazo</th>
            <th>Frecuencia</th>
            <th>Tipo</th>
            <th>Cuota estimada</th>
            <th>Estado</th>
            <th>Fecha</th>
        </tr>
    </thead>
    <tbody>
        <?php while($row = $resultado->fetch_assoc()): 
            $monto = $row['monto'];
            $tasa = $row['tasa'] / 100;
            $plazo = $row['plazo'];
            $tipo = $row['tipo_interes'];
            $frecuencia = $row['frecuencia_pago'];
            $cuotas = match($frecuencia) {
                "mensual" => $plazo * 12,
                "quincenal" => $plazo * 24,
                "semanal" => $plazo * 52,
                "anual" => $plazo,
                default => 1
            };

            // Cálculo de cuota aproximada
            if ($tipo === 'simple') {
                $total = $monto * (1 + $tasa * $plazo);
            } else {
                $total = $monto * pow(1 + $tasa, $plazo);
            }
            $cuota = $total / $cuotas;
        ?>
        <tr>
            <td>RD$<?= number_format($monto, 2) ?></td>
            <td><?= number_format($row['tasa'], 2) ?>%</td>
            <td><?= $plazo ?> años</td>
            <td><?= ucfirst($frecuencia) ?></td>
            <td><?= ucfirst($tipo) ?></td>
            <td>RD$<?= number_format($cuota, 2) ?></td>
            <td><?= ucfirst($row['estado']) ?></td>
            <td><?= date("d/m/Y", strtotime($row['fecha_prestamo'])) ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<a href="sesion_iniciada.php" class="uk-button uk-button-default">Volver</a>

</body>
</html>
