function sendMessage() {
    var messageInput = document.getElementById('message-input');
    var messageText = messageInput.value.trim();
    
    if (messageText !== '') {
        var conversationPanel = document.getElementById('conversation-panel');
        var messageContainer = document.createElement('div');
        messageContainer.classList.add('message', 'sent');
        var pseudoName = document.createElement('div');
        pseudoName.classList.add('pseudo-name');
        pseudoName.textContent = 'Usuario';
        var messageBody = document.createElement('div');
        messageBody.classList.add('chat-message');
        messageBody.textContent = messageText;
        messageContainer.appendChild(pseudoName);
        messageContainer.appendChild(messageBody);
        conversationPanel.appendChild(messageContainer);

        var inputContainer = document.getElementById('input-container');
        inputContainer.style.display = 'none';

        // Respuesta automática del ChatBot
        setTimeout(function() {
            var chatBotMessage = document.createElement('div');
            chatBotMessage.classList.add('message');
            var chatBotPseudoName = document.createElement('div');
            chatBotPseudoName.classList.add('pseudo-name');
            chatBotPseudoName.textContent = 'ChatBot';
            var chatBotMessageBody = document.createElement('div');
            chatBotMessageBody.classList.add('chat-message');
            if (messageText === 'Como puedo comunicarme con la tienda') {
                chatBotMessageBody.textContent = "Puedes comunicarte directamente con la tienda a través del siguiente número telefónico, '829-807-9028'";
            } else if (messageText === 'Como puedo hacer una cita?') {
                chatBotMessageBody.textContent = "Para hacer una cita necesitas ir al apartado de cita, llenar los campos y esperar respuestas de los administradores";
            } else if (messageText === 'Como puedo comprar un producto?') {
                chatBotMessageBody.textContent = "Hay 2 formas de las que puedes comprar o adquirir un producto. La primera es yendo a la tienda física; para saber dónde queda, ve al apartado de ubicaciones en la página y podrás ir a nuestra tienda más cercana. La segunda forma es a través de nuestro sitio web; ve al apartado de productos y sigue los pasos que te indica para comprar un producto. Después de comprar el producto y confirmar tu compra, tienes la decisión de sacar un PDF de la factura y esperar a que el producto sea enviado.";
            } else {
                chatBotMessageBody.textContent = 'Tengo 3 opciones que podrán servirte para que elijas cuál se asimila más a tu problema';
            }
            var chatBotButtons = document.createElement('div');
            chatBotButtons.classList.add('chatbot-buttons');
            var button1 = createChatBotButton('Soy gay');
            var button2 = createChatBotButton('No soy gay');
            var button3 = createChatBotButton('Tal vez soy gay');
            chatBotButtons.appendChild(button1);
            chatBotButtons.appendChild(button2);
            chatBotButtons.appendChild(button3);
            chatBotMessage.appendChild(chatBotPseudoName);
            chatBotMessage.appendChild(chatBotMessageBody);
            chatBotMessage.appendChild(document.createElement('br'));
            chatBotMessage.appendChild(chatBotButtons);
            conversationPanel.appendChild(chatBotMessage);
        }, 1000);

        // pone el tema
        var previewMessage = document.getElementById('preview-message');
        if (previewMessage.textContent === 'Mensaje de vista previa...') {
            previewMessage.textContent = messageText;
        }

        messageInput.value = '';
    }
}

function handleKeyPress(event) {
    if (event.keyCode === 13) {
        event.preventDefault(); // Evita el comportamiento predeterminado del Enter
        sendMessage(); // Llama a la función sendMessage() al presionar Enter
    }
}

function createChatBotButton(label) {
    var button = document.createElement('button');
    button.classList.add('chatbot-button');
    if (label === 'Soy gay') {
        label = 'Como puedo comunicarme con la tienda';
    } else if (label === 'No soy gay') {
        label = 'Como puedo hacer una cita?';
    } else if (label === 'Tal vez soy gay') {
        label = 'Como puedo comprar un producto?';
    }
    button.textContent = label;
    button.onclick = function() {
        sendMessageFromChatBot(label);
        button.classList.add('selected');
        var otherButtons = document.querySelectorAll('.chatbot-button:not(.selected)');
        otherButtons.forEach(function(otherButton) {
            otherButton.classList.add('disabled');
        });
    };
    return button;
}

function sendMessageFromChatBot(message) {
    var conversationPanel = document.getElementById('conversation-panel');
    var messageContainer = document.createElement('div');
    messageContainer.classList.add('message');
    var pseudoName = document.createElement('div');
    pseudoName.classList.add('pseudo-name');
    pseudoName.textContent = 'ChatBot';
    var messageBody = document.createElement('div');
    messageBody.classList.add('chat-message');
    if (message === 'Como puedo comunicarme con la tienda') {
        messageBody.textContent = "Puedes comunicarte directamente con la tienda a través del siguiente número telefónico, '829-807-9028'";
    } else if (message === 'Como puedo hacer una cita?') {
        messageBody.textContent = "Para hacer una cita necesitas ir al apartado de cita, llenar los campos y esperar respuestas de los administradores";
    } else if (message === 'Como puedo comprar un producto?') {
        messageBody.textContent = "Hay 2 formas de las que puedes comprar o adquirir un producto. La primera es yendo a la tienda física; para saber dónde queda, ve al apartado de ubicaciones en la página y podrás ir a nuestra tienda más cercana. La segunda forma es a través de nuestro sitio web; ve al apartado de productos y sigue los pasos que te indica para comprar un producto. Después de comprar el producto y confirmar tu compra, tienes la decisión de sacar un PDF de la factura y esperar a que el producto sea enviado.";
    } else {
        messageBody.textContent = message;
    }
    messageContainer.appendChild(pseudoName);
    messageContainer.appendChild(messageBody);

    // Agregar botones de respuesta debajo de la respuesta del ChatBot
    var responseButtons = document.createElement('div');
    responseButtons.classList.add('response-buttons');
    var responseButton1 = document.createElement('button');
    responseButton1.classList.add('response-button');
    responseButton1.innerHTML = '<span class="like-icon">&#128077;</span>';
    responseButton1.onclick = function() {
        handleResponse('Me sirve');
        responseButton1.classList.add('selected');
        responseButton2.classList.add('disabled');
    };
    var responseButton2 = document.createElement('button');
    responseButton2.classList.add('response-button');
    responseButton2.innerHTML = '<span class="dislike-icon">&#128078;</span>';
    responseButton2.onclick = function() {
        handleResponse('No me sirve');
        responseButton1.classList.add('disabled');
        responseButton2.classList.add('selected');
    };
    var responseText = document.createElement('span');
    responseText.classList.add('response-text');
    responseText.textContent = '¿Esta respuesta te sirvió?';
    responseButtons.appendChild(responseButton1);
    responseButtons.appendChild(responseButton2);
    responseButtons.appendChild(responseText);
    messageContainer.appendChild(responseButtons);

    conversationPanel.appendChild(messageContainer);
}