document.addEventListener("keyup", e => {
  if (e.target.matches("#buscador")) {
      if (e.key === "Escape") e.target.value = "";

      const searchTerm = e.target.value.toLowerCase();

      let found = false;

      document.querySelectorAll(".kk").forEach(carro => {
          const nombre = carro.querySelector(".titulo-item").textContent.toLowerCase();
          if (nombre.includes(searchTerm)) {
              carro.classList.remove("filtro");
              found = true;
          } else {
              carro.classList.add("filtro");
          }
      });

      if (!found && e.key === "Enter") {  
          Swal.fire({
              icon: "error",
              title: "Oops...",
              text: "No se encuentra el carro que esta buscando!",
            });
      }
    }
});
