<?php
// Incluye el archivo de conexión a la base de datos
include 'conexion.php';

// Inicia la sesión para manejar variables de sesión
session_start();

// Verifica si la variable de sesión 'nombre' no está establecida
if (!isset($_SESSION['nombre'])) {
    // Si 'nombre' no está establecida, redirige al usuario a la página de inicio de sesión
    header("Location: iniciar_sesion.php");
    exit(); // Finaliza la ejecución del script
}

// Obtiene el ID del usuario de la variable de sesión
$id = $_SESSION["id"];

// Consulta a la base de datos para obtener puntos y totalpor del usuario
$sql2 = "SELECT * FROM usuarios WHERE id = $id";
$resul2 = $conexion->query($sql2);

// Recorre los resultados de la consulta
while($row2 = $resul2->fetch_assoc()) {
    // Almacena los puntos del usuario en la variable $bb
    $bb = $row2["puntos"];
    // Almacena el totalpor del usuario en la variable $totalpor
    $totalpor = $row2["totalpor"]; 
}
?>


<html>
<head>
  <meta charset="UTF-8">
  <title>Calendario de Tareas</title>
  <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900|Material+Icons'>
  <link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/vuetify@1.5.14/dist/vuetify.min.css'><link rel="stylesheet" href="Estilos/Calendario.css">
  <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- UIkit CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/css/uikit.min.css" />
    <!-- UIkit JS -->
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.17.11/dist/js/uikit-icons.min.js"></script>
</head>
<body>
<nav uk-dropnav="align: center">
        <ul class="uk-subnav uk-flex-left uk-margin-medium-top uk-margin-medium-bottom uk-margin-medium-left">
            <li class="uk-active"><a href="Index.php">Home</a></li>
            <li>
                <a href>Menu <span uk-drop-parent-icon></span></a>
                <div class="uk-dropdown">
                    <ul class="uk-nav uk-dropdown-nav">
                        <li class="uk-active"><a href="Informacion.php">Informacion</a></li>
                        <li class="uk-active"><a href="Manual.php">Manual de usuario </a></li>
                        <li><a href="cerrar.php">cerrar Sesion</a></li>
                     
                    </ul>
                </div>
            </li>
            <li>
                <a href>Calculadora <span uk-drop-parent-icon></span></a>
                <div class="uk-dropdown">
                    <ul class="uk-nav uk-dropdown-nav">
                        <li><a href="Cartasparatareas.php">Tareas</a></li>
                        <li><a href="Calculadora.php">Calcular</a></li>
                        <li><a href="Calendario.php">Calendario</a></li>
                    </ul>
                </div>
                <li>Fidepuntos</li>
                <li><?php echo $bb; ?></li>
                <li><a href="">porcentaje: <?php echo $totalpor . "%" ?></a></li>
            </li>
        </ul>
    </nav>

<v-container id="app">
  <v-app id="inspire">
    <v-layout class="white" row wrap>
      <v-flex xs12 sm5 class="botón-grupo-calendario-flexible">
        <v-btn-toggle v-model="tipoCalendario" class="botón-grupo-calendario">
              <v-btn class="botón-grupo-calendario"  flat value="day" @click="tipoCalendario = 'day'">
                <span>Dia</span>
                <v-icon>view_day</v-icon>
              </v-btn>
              <v-btn class="botón-grupo-calendario" flat value="week" @click="tipoCalendario = 'week'">
                <span>Semana</span>
                <v-icon>view_week</v-icon>
              </v-btn>
              <v-btn class="botón-grupo-calendario" flat value="month" @click="tipoCalendario = 'month'">
                <span>Mes</span>
                <v-icon>view_module</v-icon>
              </v-btn>
            </v-btn-toggle>
      </v-flex>
    <v-flex xs2 sm1>
        <v-btn icon class="boton-direcional" @click="volver">
          <v-icon>keyboard_arrow_left</v-icon>
        </v-btn>
      </v-flex>
      
      
      <!-- selector de fecha/mes -->


      <v-flex xs8 sm5 class="modal-mes-flex">
      <v-dialog v-if="tipoCalendario == 'month'"
        ref="modalMes"
        v-model="modalMes"
        :return-value.sync="mes"
        lazy
        full-width
        width="290px"
        locale="esp"
      >
        <template v-slot:activator="{ on }">
          <v-text-field
            v-model="textoMesSelecionado"
            label="Mes"
            prepend-icon="event"
            readonly
            v-on="on"
          ></v-text-field>
        </template>
        <v-date-picker locale="esp" v-model="mes" type="month" scrollable @input="selecionarData($event)">
        </v-date-picker>
      </v-dialog>
        
      <v-dialog v-else
        ref="modalDiaSemana"
        v-model="modalDiaSemana"
        :return-value.sync="diaSemana"
        lazy
        full-width
        width="290px"
      >
        <template v-slot:activator="{ on }">
          <v-text-field
            v-model="fechaDíaSemanaFormateado"
            label="Dia"
            prepend-icon="event"
            readonly
            v-on="on"
          ></v-text-field>
        </template>
        <v-date-picker @input="guardarDíaSemana($event)" v-model="diaSemana" scrollable locale="esp">          
        </v-date-picker>
      </v-dialog>
    </v-flex>
      <v-flex xs2 sm1>
        <v-btn icon class="boton-direcional right" @click="avanzar">
          <v-icon>keyboard_arrow_right</v-icon>
        </v-btn>
      </v-flex>
    </v-layout>
    <v-layout>
      <v-flex xs12>
        <v-sheet height="500">
          <v-calendar
            :interval-minutes="30"
            :interval-count="48"
            :interval-format="intervalodeformateo"
            locale="esp"
            @click:date="Registrarnuevatarea"
            :now="hoy"
            color="primary"
            ref="calendario"
            v-model="dataAtualCalendario"
            :type="tipoCalendario"
            v-touch="{
              left: () => avanzar(),
              right: () => volver()
            }"
          >
            <template v-slot:day="{ date, time, year, month, day, hour, minute, weekday, hasDay, hasTime, past, present, future }">
              
              <v-container class="container-mes" fill-height v-ripple @click="Registrarnuevatarea({ date, time, year, month, day, hour, minute, weekday, hasDay, hasTime, past, present, future })" >
              <template v-for="event in eventosMapa[date]">
                <v-menu
                  :key="event.titulo"
                  v-model="event.abierto"
                  :close-on-content-click="false"                   offset-x
                >
                  <template v-slot:activator="{ on }">
                    <div                      
                      v-ripple
                      class="compromiso"
                      :class="event.Color ? event.Color : blue"
                      v-on="on"
                      @mousedown.stop
                      @click.stop
                      @touchstart.stop
                      v-html="event.titulo"
                    ></div>
                  </template>
                  <v-card
                    color="grey lighten-4"
                    min-width="350px"
                    flat
                  >
                    <v-toolbar
                      :color="event.Color"
                      dark
                    >
                    <v-tooltip top>
      <template v-slot:activator="{ on }"> 
                      <v-toolbar-title v-on="on" v-html="event.titulo"></v-toolbar-title>
        </template>
      <span>{{event.titulo}}</span>
    </v-tooltip>
                      <v-spacer></v-spacer>
                      <div v-if="pantalla > 768">
                        <v-btn @click="seleccionarparaeditar(event)" icon>
                        <v-icon>edit</v-icon>
                      </v-btn>
                      <v-btn icon @click="eliminartarea(event.id); event.abierto = false;">
                        <v-icon>delete_forever</v-icon>
                      </v-btn>
                      </div>
                      <v-menu v-else bottom left>
            <template v-slot:activator="{ on }">
              <v-btn
                dark
                icon
                v-on="on"
              >
                <v-icon>more_vert</v-icon>
              </v-btn>
            </template>

            <v-list>
              <v-list-tile                        @click="seleccionarparaeditar(event)"
              > 
                <v-list-tile-title>Editar</v-list-tile-title>
              </v-list-tile>
              <v-list-tile                           @click="eliminartarea(event.id); event.abierto = false;"
              >
                <v-list-tile-title>Borrar</v-list-tile-title>
              </v-list-tile>
            </v-list>
          </v-menu>
                      <v-btn icon @click="event.abierto = false">
                        <v-icon>close</v-icon>
                      </v-btn>
      
                  <!-- Arreglar bug del boton -->

                      <v-btn icon v-if="pantalla <= 768">
                        <v-icon></v-icon>
                      </v-btn>
                    </v-toolbar>
                    <v-card-text>
                      <v-layout row wrap v-if="event.Detalles">
                        <v-flex xs2>
                          <v-icon>chat</v-icon>                      
                        </v-flex>
                        <v-flex xs10>
                          <span v-html="event.Detalles.replace(/\n/g, '<br/>')"></span>
                        </v-flex>
                      </v-layout>
                      <br v-if="event.Detalles"/>
                      <v-layout row wrap>
                        <v-flex xs2>
                          <v-icon>today</v-icon>                      
                        </v-flex>
                        <v-flex xs10>
                          <span>{{regresarfechaeditada(event.date)}}</span>
                        </v-flex>
                      </v-layout>
                      <br/>
                      <v-layout row wrap>
                        <v-flex xs2>
                          <v-icon>access_time</v-icon>                      
                        </v-flex>
                        <v-flex xs10>
                        <span>{{event.time}}</span>
                        </v-flex>
                      </v-layout>
                    </v-card-text>
                  </v-card>
                </v-menu>
              </template>
                </v-container>
            </template>
            
            <!-- día y semana -->

            <template v-slot:interval="{ date, time, year, month, day, hour, minute, weekday, hasDay, hasTime, past, present, future }">
              
            <v-container class="container-mes" fill-height v-ripple @click="Registrarnuevatarea({ date, time, year, month, day, hour, minute, weekday, hasDay, hasTime, past, present, future })">
              <template v-for="event in retornarEventosPorHora(date, hour, minute)">
                <v-menu
                  :key="event.titulo"
                  v-model="event.abierto"
                  :close-on-content-click="false"
                  offset-x
                  min-width="100px"
                >
                  <template v-slot:activator="{ on }">
                  <div                       
                    v-ripple
                    class="Tarea"
                    :class="event.Color ? event.Color : blue"
                    v-html="event.titulo"
                    @mousedown.stop
                      @click.stop
                      @touchstart.stop
                      v-on="on"
                  ></div>
                  </template>
                  <v-card
                    color="grey lighten-4"
                    flat
                  >
                    <v-toolbar
                      :color="event.Color"
                      dark
                    >
                    <v-tooltip top>
      <template v-slot:activator="{ on }"> 
                      <v-toolbar-title v-on="on" v-html="event.titulo"></v-toolbar-title>
        </template>
      <span>{{event.titulo}}</span>
    </v-tooltip>
                      <v-spacer></v-spacer>
                      <div v-if="pantalla > 768">
                        <v-btn @click="seleccionarparaeditar(event)" icon>
                        <v-icon>edit</v-icon>
                      </v-btn>
                      <v-btn icon @click="eliminartarea(event.id); event.abierto = false;">
                        <v-icon>delete_forever</v-icon>
                      </v-btn>
                      </div>
                      <v-menu v-else bottom left>
            <template v-slot:activator="{ on }">
              <v-btn
                dark
                icon
                v-on="on"
              >
                <v-icon>more_vert</v-icon>
              </v-btn>
            </template>

            <v-list>
              <v-list-tile                        @click="seleccionarparaeditar(event)"
              > 
                <v-list-tile-title>Editar</v-list-tile-title>
              </v-list-tile>
              <v-list-tile                           @click="eliminartarea(event.id); event.abierto = false;"
              >
                <v-list-tile-title>Borrar</v-list-tile-title>
              </v-list-tile>
            </v-list>
          </v-menu>
                      <v-btn icon @click="event.abierto = false">
                        <v-icon>close</v-icon>
                      </v-btn>
                    </v-toolbar>
                    <v-card-text>
                      <v-layout row wrap v-if="event.Detalles">
                        <v-flex xs2>
                          <v-icon>chat</v-icon>                      
                        </v-flex>
                        <v-flex xs10>
                          <span v-html="event.Detalles.replace(/\n/g, '<br/>')"></span>
                        </v-flex>
                      </v-layout>
                      <br v-if="event.Detalles"/>
                      <v-layout row wrap>
                        <v-flex xs2>
                          <v-icon>today</v-icon>                      
                        </v-flex>
                        <v-flex xs10>
                        <span>{{regresarfechaeditada(event.date)}}</span>
                        </v-flex>
                      </v-layout>
                      <br/>
                      <v-layout row wrap>
                        <v-flex xs2>
                          <v-icon>access_time</v-icon>                      
                        </v-flex>
                        <v-flex xs10>
                          <span>{{event.time}}</span>
                        </v-flex>
                      </v-layout>
                    </v-card-text>
                  </v-card>
                  </v-menu>
              </template>
            </v-container>
          </template>
            
          </v-calendar>
        </v-sheet>
      </v-flex>
    </v-layout>

    <!--Añadir nueva tarea -->

    <v-dialog :scrollable="pantalla > 768" @keydown.enter="guardarTarea" v-model="NuevamodalidaddeCompromiso" max-width="600px" :fullscreen="pantalla <= 768" :transition="pantalla <= 768 ? 'slide-x-transition' : 'dialog-transition'">
      <v-card>
        <v-card-title>
          <span class="headline">Tarea</span>
          <v-spacer></v-spacer>
          <v-btn icon @click="NuevamodalidaddeCompromiso = false">
            <v-icon>close</v-icon>
          </v-btn>
        </v-card-title>
        <v-divider></v-divider>
        <v-card-text :style="pantalla > 768 ? 'height: 500px;' : ''">
          <v-form ref="formulariotarea">
            <v-container grid-list-md>
            <v-layout wrap>
              <v-flex xs12>
                <v-text-field ref="tituloNovoCompromisso" v-model="nuevaTarea.titulo" label="Título" :rules="regrasTitulo"></v-text-filed>
              </v-flex>
              <v-flex xs12>
                <v-textarea  v-model="nuevaTarea.Detalles" label="Detalles" outline></v-textarea>
              </v-flex>
              <v-flex xs6>
                <v-dialog
        ref="dialog"
        v-model="modalData"
        :return-value.sync="nuevaTarea.date"
        persistent
        lazy
        full-width
        width="290px"
      >
        <template v-slot:activator="{ on }">
          <v-text-field
            v-model="fechaTareaFormateado"
            label="Fecha"
            prepend-icon="event"
            readonly
            v-on="on"
            :rules="reglasFecha"
          ></v-text-field>
        </template>
        <v-date-picker locale="esp" v-model="nuevaTarea.date" scrollable>
          <v-spacer></v-spacer>
          <v-btn flat color="primary" @click="modalData = false">Cancelar</v-btn>
          <v-btn flat color="primary" @click="$refs.dialog.save(nuevaTarea.date)">OK</v-btn>
        </v-date-picker>
      </v-dialog>
              </v-flex>
              <v-flex xs6>
                <v-dialog
                          scrollable
        ref="modalHora"
        v-model="modalHora"
        :return-value.sync="nuevaTarea.time"
        persistent
        lazy
        full-width
        width="290px"
      >
        <template v-slot:activator="{ on }">
          <v-text-field
            v-model="nuevaTarea.time"
            label="Hora"
            prepend-icon="access_time"
            readonly
            v-on="on"
            :rules="regrasHora"
          ></v-text-field>
        </template>
                  <v-card>
        <v-card-text style="height: 365px; padding: 0px">
          <v-time-picker
          v-if="modalHora"
          v-model="nuevaTarea.time"
          full-width
          format="24hr"
          locale="esp"
        ></v-time-picker>
                  </v-card-text>
                  <v-card-actions>
                    <v-btn flat color="primary" @click="modalHora = false">Cancelar</v-btn>
          <v-btn flat color="primary" @click="guardarHoraNuevatarea">Aceptar</v-btn>
                  </v-card-actions>
                    </v-card>
      </v-dialog>
              </v-flex>
              <v-flex xs12>
                <v-select @keydown.enter.stop.prevent :color="nuevaTarea.Color" v-model="nuevaTarea.Color" :items="colores" label="Color">
                  <template v-slot:append>
                  <div :class="nuevaTarea.Color" class="cuadradodecolor"></div>
                  </template>
                  <template v-slot:item={item}>
                    <div :class="item.value" class="cuadradodecolor-Color"></div>{{item.text}}
                  </template>
                </v-select>
              </v-flex>
            </v-layout>
          </v-container>
          </v-form>          
        </v-card-text>
        <v-card-actions>
          <v-spacer></v-spacer>
          <v-btn color="scondary" flat @click="NuevamodalidaddeCompromiso = false">Cancelar</v-btn>
          <v-btn @click="guardarTarea" color="success"  @click="NuevamodalidaddeCompromiso = false">{{botóndeGuardar}}</v-btn>
        </v-card-actions>         
      </v-card>
    </v-dialog>
    <v-btn v-model="Añadirbotónvisible" @click="Registrarnuevatarea()" fixed bottom right fab dark small color="primary">
      <v-icon dark>add</v-icon>
    </v-btn>
  </v-app>
</div>

<!-- Librerias-->
  <script src='https://cdn.jsdelivr.net/npm/babel-polyfill/dist/polyfill.min.js'></script>
<script src='https://cdn.jsdelivr.net/npm/vue/dist/vue.js'></script>
<script src='https://cdn.jsdelivr.net/npm/vuetify@1.5.14/dist/vuetify.min.js'></script>
<script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.24.0/moment.min.js'></script><script  src="JavaScript/Calendario.js"></script>

</body>
</html>
