new Vue({
  el: "#app",
  data: () => ({
    anchoPantalla: 0,
    idInterno: 0,
    NuevamodalidaddeCompromiso: false,
    modalDiaSemana: false,
    tipoCalendario: "month",
    modalMes: false,
    modalHora: false,
    modalData: false,
    Añadirbotónvisible: true,
    mes: new Date().toISOString().substr(0, 7),
    ano: parseInt(new Date().toISOString().substr(0, 4)),
    dataAtualCalendario: moment().format("YYYY-MM-DD"),
    diaSemana: new Date().toISOString().substr(0, 10),
    colores: [
      { value: "blue", text: "Azul" },
      { value: "green", text: "Verde" },
      { value: "yellow", text: "Amarillo" },
      { value: "orange", text: "Naranja" },
      { value: "purple", text: "Morado" },
      { value: "red", text: "Verde" },
      { value: "black", text: "Negro" },
    ],

    nuevaTarea: {
      id: 0,
      titulo: "",
      Detalles: "",
      date: "",
      abierto: false,
      Color: "blue",
      hour: 0,
      minute: 0,
      time: "",
    },

    hoy: moment().format("YYYY-MM-DD"),
    events: [],
    regrasTitulo: [
      (v) => !!v || "Por favor proporcione el título de la tarea.",
      (v) =>
        v.length <= 30 || "El título debe contener un máximo de 30 caracteres.",
    ],

    reglasFecha: [(v) => !!v || "Por favor, proporcione la fecha de la cita."],

    reglasFecha: [(v) => !!v || "Por favor, proporcione la hora de la cita."],
  }),

  computed: {
    fechaDíaSemanaFormateado() {
      if (this.diaSemana == "") {
        return "";
      }
      return moment(this.diaSemana, "YYYY-MM-DD").format("DD/MM/YYYY");
    },
    fechaTareaFormateado() {
      if (this.nuevaTarea.date == "") {
        return "";
      }
      return moment(this.nuevaTarea.date, "YYYY-MM-DD").format("DD/MM/YYYY");
    },
    textoMesSelecionado() {
      let mesSelecionado = parseInt(this.mes.split("-")[1]);
      let meses = [
        "Enero",
        "Febrero",
        "Marzo",
        "Abril",
        "Mayo",
        "Junio",
        "Julio",
        "Agosto",
        "Septiembre",
        "Octubre",
        "Noviembre",
        "Diciembre",
      ];

      return meses[mesSelecionado - 1] + " de " + this.ano;
    },
    botóndeGuardar() {
      return this.nuevaTarea.id ? "Editar" : "Agregar";
    },
    // convert the list of events into a map of lists keyed by date
    eventosMapa() {
      const map = {};
      this.events.forEach((e) => (map[e.date] = map[e.date] || []).push(e));
      return map;
    },
  },

  methods: {
    estilizarDiasSemana(tipoCalendario) {
      if (tipoCalendario == "week" || tipoCalendario == "day") {
        setTimeout(() => {
          var elementos = document.querySelectorAll(
            ".v-calendar-daily_head-day-label"
          );
          if (elementos.length > 1) {
            elementos.forEach((e) => {
              e.classList.add("label-dia-semana");
            });
          } else if (elementos.length == 1) {
            elementos[0].classList.remove("label-dia-semana");
          }
        }, 50);
      }
    },
    regresarfechaeditada(data) {
      return moment(data, "YYYY-MM-DD").format("DD/MM/YYYY");
    },
    intervalodeformateo(i) {
      return i.time;
    },
    retornarEventosPorHora(data, hora, minuto) {
      return this.events.filter((ev) => {
        if (ev.date == data && ev.hour == hora) {
          if (minuto == 0 && ev.minute <= 29) {
            return true;
          } else if (minuto == 30 && ev.minute >= 30) {
            return true;
          }
        }
        return false;
      });
    },
    guardarDíaSemana(e) {
      this.modalDiaSemana = false;
      this.dataAtualCalendario = e;
      this.$refs.modalDiaSemana.save(e);
      var split = e.split("-");
      this.ano = parseInt(split[0]);
      this.mes = split[0] + "-" + split[1];
    },
    avanzar() {
      switch (this.tipoCalendario) {
        case "month":
          this.$refs.calendario.next();
          let mesAtual = parseInt(this.mes.split("-")[1]);
          mesAtual++;
          if (mesAtual > 12) {
            mesAtual = 1;
            this.ano++;
          }
          this.mes = this.ano + "-" + mesAtual;
          this.dataAtualCalendario = this.mes + "-01";
          break;
        case "day":
          this.$refs.calendario.next();
          this.diaSemana = moment(this.diaSemana, "YYYY-MM-DD")
            .add(1, "days")
            .format("YYYY-MM-DD");
          this.dataAtualCalendario = this.diaSemana;
          this.ano = parseInt(this.dataAtualCalendario.split("-")[0]);
          this.mes =
            this.dataAtualCalendario.split("-")[0] +
            "-" +
            this.dataAtualCalendario.split("-")[1];
          break;
        case "week":
          this.$refs.calendario.next();
          this.diaSemana = moment(this.diaSemana, "YYYY-MM-DD")
            .day(7) //próximo domingo
            .format("YYYY-MM-DD");
          this.dataAtualCalendario = this.diaSemana;
          this.ano = parseInt(this.dataAtualCalendario.split("-")[0]);
          this.mes =
            this.dataAtualCalendario.split("-")[0] +
            "-" +
            this.dataAtualCalendario.split("-")[1];
          break;
      }

      this.estilizarDiasSemana(this.tipoCalendario);
    },
    volver() {
      switch (this.tipoCalendario) {
        case "month":
          this.$refs.calendario.prev();
          let mesAtual = parseInt(this.mes.split("-")[1]);

          mesAtual--;
          if (mesAtual < 1) {
            mesAtual = 12;
            this.ano--;
          }
          this.mes = this.ano + "-" + mesAtual;
          this.dataAtualCalendario = this.mes + "-01";
          break;
        case "day":
          this.$refs.calendario.prev();
          this.diaSemana = moment(this.diaSemana, "YYYY-MM-DD")
            .add(-1, "days")
            .format("YYYY-MM-DD");
          this.dataAtualCalendario = this.diaSemana;
          this.ano = parseInt(this.dataAtualCalendario.split("-")[0]);
          this.mes =
            this.dataAtualCalendario.split("-")[0] +
            "-" +
            this.dataAtualCalendario.split("-")[1];
          break;
        case "week":
          this.$refs.calendario.prev();
          this.diaSemana = moment(this.diaSemana, "YYYY-MM-DD")
            .day(-7) //domingo anterior
            .format("YYYY-MM-DD");
          this.dataAtualCalendario = this.diaSemana;
          this.ano = parseInt(this.dataAtualCalendario.split("-")[0]);
          this.mes =
            this.dataAtualCalendario.split("-")[0] +
            "-" +
            this.dataAtualCalendario.split("-")[1];
          break;
      }

      this.estilizarDiasSemana(this.tipoCalendario);
    },
    selecionarData(e) {
      this.modalMes = false;
      this.$refs.modalMes.save(e);
      this.dataAtualCalendario = e + "-01";
      this.diaSemana = this.dataAtualCalendario;
      this.ano = parseInt(e.split("-")[0]);
    },
    Registrarnuevatarea(e) {
      this.nuevaTarea = {
        titulo: "",
        Detalles: "",
        date: "",
        abierto: false,
        Color: "blue",
        hour: 0,
        minute: 0,
        time: "",
      };

      this.$refs.formulariotarea.resetValidation();
      if (e) {
        this.nuevaTarea.date = e.date;
        this.nuevaTarea.hour = e.hour;
        this.nuevaTarea.minute = e.minute;
        this.nuevaTarea.time = e.time;
      }
      this.NuevamodalidaddeCompromiso = true;
      setTimeout(() => {
        this.$refs.nuevaTarea.focus();
      }, 300);
    },
    retornarProximoId() {
      this.idInterno++;
      return this.idInterno;
    },
    seleccionarparaeditar(compr) {
      this.nuevaTarea = {
        id: compr.id,
        titulo: compr.titulo,
        Detalles: compr.Detalles,
        date: compr.date,
        abierto: compr.abierto,
        Color: compr.Color,
        hour: compr.hour,
        minute: compr.minute,
        time: compr.time,
      };

      this.NuevamodalidaddeCompromiso = true;
    },
    guardarTarea() {
      if (!this.$refs.formulariotarea.validate()) {
        return;
      }

      if (!this.nuevaTarea.id) {
        //agregar
        this.nuevaTarea.id = this.retornarProximoId();
        this.events.push(this.nuevaTarea);
      } else {
        //editar
        let tarea = this.events.find((e) => {
          return e.id == this.nuevaTarea.id;
        });
        tarea.titulo = this.nuevaTarea.titulo;
        tarea.Detalles = this.nuevaTarea.Detalles;
        tarea.Color = this.nuevaTarea.Color;
        tarea.hour = this.nuevaTarea.hour;
        tarea.minute = this.nuevaTarea.minute;
        tarea.time = this.nuevaTarea.time;
        tarea.date = this.nuevaTarea.date;
      }
      this.nuevaTarea = {
        titulo: "",
        Detalles: "",
        date: "",
        abierto: false,
        Color: "blue",
        hour: 0,
        minute: 0,
        time: "",
      };

      this.NuevamodalidaddeCompromiso = false;
      this.$refs.formulariotarea.resetValidation();
    },
    eliminartarea(id) {
      if (confirm("¿Está seguro de que desea eliminar esta tarea?")) {
        var index = this.events.findIndex((e) => {
          return e.id == id;
        });
        this.events.splice(index, 1);
      }
    },
    guardarHoraNuevatarea() {
      this.$refs.modalHora.save(this.nuevaTarea.time);
      let horaMinuto = this.nuevaTarea.time.split(":");
      this.nuevaTarea.hour = horaMinuto[0];
      this.nuevaTarea.minute = horaMinuto[1];
    },
  },

  created() {
    this.anchoPantalla = window.innerWidth;
  },
  watch: {
    NuevamodalidaddeCompromiso(v) {
      if (!v) {
        this.$refs.formulariotarea.resetValidation();
        this.Añadirbotónvisible = true;
      } else {
        this.Añadirbotónvisible = false;
      }
    },
    tipoCalendario(tipo) {
      this.estilizarDiasSemana(tipo);
    },
  },
});