<?php
//incluyendo los achivos de conexion y gestor de archivo//
include 'conexion.php';
include 'imagenes.php';



if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = $_POST["name"];
    $correo = $_POST["correo"];
    $contra = $_POST["password"];
    
    // Verificar si el nombre de usuario ya existe
    $consulta_existencia = $conexion->prepare("SELECT * FROM usuarios WHERE nombre = ?");
    $consulta_existencia->bind_param("s", $name);
    $consulta_existencia->execute();
    $resultado_existencia = $consulta_existencia->get_result();

    if ($resultado_existencia->num_rows > 0) {
        echo "Error: Este nombre de usuario ya está registrado. Por favor, elige otro.";
    } else {
        // Insertar nuevo usuario
        $consulta_registro = $conexion->prepare("INSERT INTO usuarios (nombre, email, contrasena) VALUES (?, ?, ?)");
        $consulta_registro->bind_param("sss", $name, $correo, $contra);
        $consulta_registro->execute();

        // Verificar el registro
        $consulta_verificacion = $conexion->prepare("SELECT * FROM usuarios WHERE nombre = ? AND contrasena = ?");
        $consulta_verificacion->bind_param("ss", $name, $contra);
        $consulta_verificacion->execute();
        $resultado_verificacion = $consulta_verificacion->get_result();

        if ($resultado_verificacion->num_rows > 0) {
            $fila = $resultado_verificacion->fetch_assoc();
            session_start();
            $_SESSION['id'] = $fila['id'];
            $_SESSION['nombre'] = $fila['nombre'];
            header("Location: index.php");
            exit();
        } else {
            echo "Error al verificar el registro.";
        }
    }
}



?>


<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <script src="https://kit.fontawesome.com/64d58efce2.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="Estilos/Registro.css"/>
    <title>Registrar</title>
  </head>
  <body>
    <div class="contenedor">
      <div class="forms-contenedor">
          <div class="iniciar-registrar">
              <form action="" id="formulario1" method='post' class="iniciar-en-form" onsubmit="validarFormulario(evento)">
                  <h2 class="titulo">Registrate:</h2>
                  <div class="input-campo">
                    <i class="fas fa-user"></i>
                    <input type="text" name="name" id="usuario1" placeholder="Usuario"/>
                  </div>
                  <div class="input-campo">
                    <i class="fas fa-lock"></i>
                    <input type="password" name="password" id="contrase1" placeholder="Contraseña"/>
                  </div>
                  <div class="input-campo">
                    <i class="fas fa-user"></i>
                    <input type="text" name="correo" id="correo" placeholder="Correo Electronico">
                  </div>
                  <input type="submit" value="Iniciar"  class="btn solid" />
                  <p class="social-text">Iniciar con</p>
                  <div class="social-media">
                    <a href="#" class="social-icon">
                      <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="social-icon">
                      <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="social-icon">
                      <i class="fab fa-google"></i>
                    </a>
                    <a href="#" class="social-icon">
                      <i class="fab fa-linkedin-in"></i>
                    </a>
                  </div>
                </form>
          </div>
      </div>
  </div>  
  <div class="paneles-contenedor">
      <div class="panel izquierda-panel">
        <div class="contenido">
          <h3>¿Quieres iniciar?</h3>
          <p>
            Inicia y sigue con tu progreso en nuestra página y mejora el mundo. 
          </p>
          <a href="Iniciar_Sesion.php "><button class="btn transparente" id="iniciar-con-btn">Iniciar</button></a>
        </div>
        <img src="<?php echo $url.$imagenes[35][0]; ?>" class="imagen" alt="" width="500px" height="500px"/>
      </div>
  <script src="JavaScript/Formulario_Iniciar_Validacion.js"></script>
</html>