<?php
session_start();
include 'include/conexion.php';
if (!isset($_SESSION['id'])) {
    header("Location: login.php");
    exit();
}


$nombre = $_SESSION['nombre'];
$producto = !empty($_POST["producto"]) ? $_POST["producto"] : null;

$mas = !empty($_GET["mas"]) ? $_GET["mas"] : null;

if (!isset($mas)) {
    exit();
}

$histo = $conexion->prepare("INSERT INTO historial (usuario, producto) VALUES (?, ?)");
$histo->bind_param("ss", $nombre, $producto);
$histo->execute();

$id = $_SESSION['id'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/uikit@3.18.3/dist/css/uikit.min.css" />
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.3/dist/js/uikit.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/uikit@3.18.3/dist/js/uikit-icons.min.js"></script>
    <title>Panadcha</title>
    <script>
        function pepe(){
        alert("Compra Exitosa")
       }
    </script>
</head>
<body>
    <?php 

        include("include/img.php");
        include("include/navbar.php");
        $sql = $conexion->prepare("SELECT * FROM produc WHERE id = ?");
        $sql->bind_param("s", $mas);
        $sql->execute();
        $result = $sql->get_result();
        if ($result->num_rows > 0) {
            foreach($result as $valores) {?>
                <div class="uk-child-width-1-1 uk-text-default" uk-grid>
                    <div>
                        <div class="uk-card uk-card-body">
                            <div class="uk-container">
                                <div class="uk-child-width-1-1 uk-child-width-1-2@m uk-text-default" uk-grid>
                                    <div class="uk-card uk-card-body">
                                        <img src="img/<?php echo $valores["img"]; ?>" style="height:600px; width:600px:" alt="">
                                    </div>
                                    <div>
                                        <form action="" method="post" onsubmit=" return pepe()">
                                            <input type="hidden" name="producto" value="<?php echo $valores["producto"]; ?>">
                                            <div class="uk-card uk-card-body">
                                                <h3>Postre: <?php echo $valores["producto"]; ?></h3>
                                                <ul>
                                                    <li>Precio: <?php echo $valores["precio"] ?></li>
                                                    <li>Descripcion: <?php echo $valores["descripcion"] ?></li>
                                                </ul>
                                                <button type="submit"  class="uk-button uk-button-primary" name="enviar">Comprar <span uk-icon="icon:  cart; ratio: 1"></span></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        <?php }
        include("include/footer.php");
        include("include/offcanvas.php");
    ?>
<script>
    function validaciond() {
        let nombre = document.getElementById('nombre').value;
        let email = document.getElementById('email').value;
        let numero = document.getElementById('numero').value;
        let asunto = document.getElementById('asunto').value;

        if (nombre.length === 0) {
            alert('Nombre esta vacio');
            return false;
        }
        if (email.length === 0) {
            alert('email esta vacio');
            return false;
        }
        if (numero.length === 0) {
            alert('el campo numero esta vacio');
            return false;
        }
        if (asunto.length == 2) {
            alert('Escriba mas caracteres');
            return false;
        }

        alert('Se envio su asunto');
        return true;
    }
</script>
</body>
</html>
